@props(['headers' => null])

@php
    $headers = explode(',', $headers);
@endphp

<!-- Table pour écrans moyens et grands -->
<div class="w-full overflow-auto">
    <table class="min-w-max text-left text-sm">
        <thead class="bg-base-100/50">
            <tr class="p-2">
                @foreach ($headers as $header)
                    <x-converge::table.th class="whitespace-nowrap px-2 py-2 md:px-4">
                        {{ $header }}
                    </x-converge::table.th>
                @endforeach
            </tr>
        </thead>
        <tbody class="">
            {{ $slot }}
        </tbody>
    </table>
</div>
