@props([
    'title' => 'Step',
    'description' => false,
    'color' => null,
    'last' => false,
    'number' => false,
    'icon' => null,
])

@php
    $colorVariants = [
        'primary' => [
            'border' => 'border-primary',
            'bg' => 'bg-primary/10',
            'text' => 'text-primary fill-primary',
            'divider' => 'bg-primary/30',
        ],
        'success' => [
            'border' => 'border-success',
            'bg' => 'bg-success/10',
            'text' => 'text-success fill-success',
            'divider' => 'bg-success/30',
        ],
        'warning' => [
            'border' => 'border-warning',
            'bg' => 'bg-warning/10',
            'text' => 'text-warning fill-warning',
            'divider' => 'bg-warning/30',
        ],
        'error' => [
            'border' => 'border-error',
            'bg' => 'bg-error/10',
            'text' => 'text-error fill-error',
            'divider' => 'bg-error/30',
        ],
        'info' => [
            'border' => 'border-info',
            'bg' => 'bg-info/10',
            'text' => 'text-info fill-info',
            'divider' => 'bg-info/30',
        ],
        'accent' => [
            'border' => 'border-accent',
            'bg' => 'bg-accent/10',
            'text' => 'text-accent fill-accent',
            'divider' => 'bg-accent/30',
        ],
    ];

    $parentColor = $attributes->get('parent-color', 'primary');
    $stepColor = isset($colorVariants[$color]) ? $color : $parentColor;

    $colorClasses = $colorVariants[$stepColor] ?? $colorVariants['primary'];

    $getIconContent = function ($icon, $number, $last, $colorClasses) {
        if ($number) {
            return $number;
        }

        if ($icon) {
            try {
                return svg($icon, ['class' => 'w-5 h-5 ' . $colorClasses['text']])->toHtml();
            } catch (\Throwable $e) {
                return $last
                    ? '<svg class="' .
                            $colorClasses['text'] .
                            ' h-5 w-5" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path><path d="m10.97 4.97-.02.022-3.473 4.425-2.093-2.094a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05"></path></svg>'
                    : '<svg class="' .
                            $colorClasses['text'] .
                            ' h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor"><path fill-rule="evenodd" clip-rule="evenodd" d="M8 9.532h.542l3.905-3.905-1.061-1.06-2.637 2.61V1H7.251v6.177l-2.637-2.61-1.061 1.06 3.905 3.905H8zm1.956 3.481a2 2 0 1 1-4 0 2 2 0 0 1 4 0z"></path></svg>';
            }
        } else {
            return $last
                ? '<svg class="' .
                        $colorClasses['text'] .
                        ' h-5 w-5" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path><path d="m10.97 4.97-.02.022-3.473 4.425-2.093-2.094a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05"></path></svg>'
                : '<svg class="' .
                        $colorClasses['text'] .
                        ' h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor"><path fill-rule="evenodd" clip-rule="evenodd" d="M8 9.532h.542l3.905-3.905-1.061-1.06-2.637 2.61V1H7.251v6.177l-2.637-2.61-1.061 1.06 3.905 3.905H8zm1.956 3.481a2 2 0 1 1-4 0 2 2 0 0 1 4 0z"></path></svg>';
        }
    };

    // Invoke the anonymous function to get icon
    $iconContent = $getIconContent($icon, $number, $last, $colorClasses);
@endphp

<div {{ $attributes->merge(['class' => 'flex']) }}>
    <div class="mr-4 flex flex-col items-center">
        <div class="flex-shrink-0">
            <div
                 class="{{ $colorClasses['border'] }} {{ $colorClasses['bg'] }} flex h-8 w-8 items-center justify-center rounded-full border-2 shadow-sm transition-all">
                {!! $iconContent !!}
            </div>
        </div>
        @if (!$last)
            <div class="{{ $colorClasses['divider'] }} h-full w-0.5 transition-all"></div>
        @endif
    </div>

    <div class="{{ !$last ? 'pb-8' : '' }} flex-1 overflow-hidden">
        <p style="margin-top: 4px"
           class="{{ $colorClasses['text'] }} text-md font-semibold transition-colors">
            {{ $title }}
        </p>

        @if ($description)
            {!! Str::of($description)->markdown([
                'html_input' => 'strip',
                'allow_unsafe_links' => false,
            ]) !!}
        @endif

        <div class="!text-base-content scrollbar-hidden mt-2 max-w-full overflow-x-auto text-base">
            {{ $slot }}
        </div>
    </div>
</div>
