@props(['name', 'active' => false, 'language' => null])
@php
    use Illuminate\Support\Str;
    use League\CommonMark\Util\HtmlFilter;
    use Tempest\Highlight\CommonMark\HighlightExtension;
    use Tempest\Highlight\Highlighter;
@endphp

<div x-show="activeTab === '{{ $name }}'"
     data-name="{{ $name }}"
     class="code-frame h-full w-full">
    {{-- {!! (new Converge\Documents\Markdown())->convert($slot) !!} --}}
    {!! Str::markdown(
        string: $slot,
        options: [
            'html_input' => HtmlFilter::ALLOW,
            'allow_unsafe_links' => false,
        ],
        extensions: [new HighlightExtension((new Highlighter())->withGutter(startAt: 1))],
    ) !!}
</div>
