@props([
    'videoId',
    'videoTitle' => null,
    'description' => null,
    'publishedDate' => null,
    'duration' => null,
    'autoplay' => true,
    'controls' => true,
    'enhancedPrivacy' => true,
    'class' => '',
])

<?php
use Carbon\Carbon;
use Converge\BladeComponents\YouTubeVideoDTO;

// Create YouTube data from component attributes
$youtubeData = YouTubeVideoDTO::fromArray([
    'videoId' => $videoId,
    'title' => $videoTitle ?? 'youtube vedio',
    'description' => $description,
    'duration' => $duration,
    'publishedAt' => $publishedDate ?? Carbon::now()->toIso8601String(),
]);

// Build embed parameters
$embedParams = http_build_query([
    'autoplay' => $autoplay ? 1 : 0,
    'controls' => $controls ? 1 : 0,
    'rel' => 0,
    'modestbranding' => 1,
]);

$embedDomain = $enhancedPrivacy ? 'youtube-nocookie.com' : 'youtube.com';
$embedUrl = "https://www.{$embedDomain}/embed/{$videoId}?{$embedParams}";
?>

<div x-data="{
    playVideo: false,
    playVideoHandler() {
        if (!this.playVideo) {
            this.playVideo = true;
        }
    }
}"
     class="{{ $class }} relative mb-4">

    <!-- Image container - Same style as the image component -->
    <div
         class="bg-base-100 border-base-300 rounded-box overflow-hidden border p-2 shadow-sm transition-all duration-200 hover:shadow-md">
        <div class="rounded-box relative flex h-[22rem] flex-col justify-start overflow-hidden">
            <!-- Thumbnail wrapper -->
            <div x-show="!playVideo"
                 class="absolute inset-0 z-10 h-full w-full">
                <!-- thumbnail -->
                <div class="flex h-full w-full bg-cover bg-center p-0">
                    <img src="https://img.youtube.com/vi/{{ $videoId }}/maxresdefault.jpg"
                         alt="{{ $videoTitle ?? 'youtube vedio' }}"
                         style="margin: 0"
                         class="h-full w-full bg-contain"
                         onload="if(this.naturalWidth == 120) {this.parentNode.style.backgroundImage = 'url(https://img.youtube.com/vi/{{ $videoId }}/0.jpg)';}"
                         onerror="this.parentNode.style.backgroundImage = 'url(https://img.youtube.com/vi/{{ $videoId }}/0.jpg)';" />
                </div>

                <!-- Play button overlay -->
                <div
                     class="absolute inset-0 flex items-center justify-center bg-black/20 transition-all duration-200 hover:bg-black/30">
                    <button type="button"
                            x-on:click="playVideoHandler"
                            class="btn btn-square btn-red-500 border-none"
                            aria-label="Play video: {{ $videoTitle }}">
                        <svg class="h-8 w-8 text-white"
                             fill="currentColor"
                             viewBox="0 0 24 24">
                            <path d="M8 5v14l11-7z" />
                        </svg>
                    </button>
                </div>
            </div>

            <div x-show="playVideo"
                 class="h-full w-full">
                <iframe x-bind:src="playVideo ? '{{ $embedUrl }}' : ''"
                        title="{{ $videoTitle }}"
                        class="h-full w-full"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                        allowfullscreen>
                </iframe>
            </div>
        </div>
    </div>
</div>
