@props([
    'color' => 'primary',
    'label' => '',
])

@php
    $isSoft = isset($attributes['soft']);
    $isOutline = isset($attributes['outline']);

    $style = match (true) {
        $isSoft => 'soft',
        $isOutline => 'outline',
        default => 'filled',
    };

    // Palette unifiée avec tes conventions (Canvas Style)
    $badgeStyles = [
        'primary' => [
            'filled' => 'bg-primary !text-primary-content',
            'outline' => 'border border-primary !text-primary',
            'soft' => 'bg-primary/6 !text-primary',
        ],
        'secondary' => [
            'filled' => 'bg-secondary !text-secondary-content',
            'outline' => 'border border-secondary !text-secondary',
            'soft' => 'bg-secondary/6 !text-secondary',
        ],
        'accent' => [
            'filled' => 'bg-accent !text-accent-content',
            'outline' => 'border border-accent !text-accent',
            'soft' => 'bg-accent/6 !text-accent',
        ],
        'info' => [
            'filled' => 'bg-info !text-info-content',
            'outline' => 'border border-info !text-info',
            'soft' => 'bg-info/6 !text-info',
        ],
        'success' => [
            'filled' => 'bg-success !text-success-content',
            'outline' => 'border border-success !text-success',
            'soft' => 'bg-success/6 !text-success',
        ],
        'warning' => [
            'filled' => 'bg-warning !text-warning-content',
            'outline' => 'border border-warning !text-warning',
            'soft' => 'bg-warning/6 !text-warning',
        ],
        'error' => [
            'filled' => 'bg-error !text-error-content',
            'outline' => 'border border-error !text-error',
            'soft' => 'bg-error/6 !text-error',
        ],
        'neutral' => [
            'filled' => 'bg-neutral !text-neutral-content',
            'outline' => 'border border-neutral !text-neutral',
            'soft' => 'bg-neutral/6 !text-neutral',
        ],
    ];

    $classes = $badgeStyles[$color][$style] ?? $badgeStyles['primary']['filled'];

    $baseClasses = 'inline-flex text-bade-content items-center gap-x-1.5 rounded-full px-3 py-1.5 text-xs font-medium';
@endphp

<span {{ $attributes->except(['soft', 'outline'])->merge(['class' => "$baseClasses $classes"]) }}>
    {{ $slot->isEmpty() ? $label : $slot }}
</span>
