@props([
    'src' => '',
    'srcStorage' => '',
    'srcPublic' => '',
    'srcLight' => '',
    'srcStorageLight' => '',
    'srcPublicLight' => '',
    'alt' => '',
    'caption' => '',
    'class' => '',
])

@php
    // Image Source (used for both light and dark mode if no light mode image passed to src light)
    $defaultImageSrc = '';
    if (!empty($src)) {
        $defaultImageSrc = $src;
    } elseif (!empty($srcStorage)) {
        $defaultImageSrc = asset('storage/' . ltrim($srcStorage, '/'));
    } elseif (!empty($srcPublic)) {
        $defaultImageSrc = asset(ltrim($srcPublic, '/'));
    }

    // Image source for light mode (if passed, else the default one will be used)
    $lightImageSrc = '';
    if (!empty($srcLight)) {
        $lightImageSrc = $srcLight;
    } elseif (!empty($srcStorageLight)) {
        $lightImageSrc = asset('storage/' . ltrim($srcStorageLight, '/'));
    } elseif (!empty($srcPublicLight)) {
        $lightImageSrc = asset(ltrim($srcPublicLight, '/'));
    } else {
        $lightImageSrc = $defaultImageSrc;
    }

    // VVerify if a light mode image has passed
    $hasLightSpecificImage = !empty($lightImageSrc) && $lightImageSrc !== $defaultImageSrc;
@endphp

<div x-data="{
    zoomed: false,
    darkMode: false,
    defaultSrc: '{{ $defaultImageSrc }}',
    lightSrc: '{{ $lightImageSrc }}',
    hasLightSpecificImage: {{ $hasLightSpecificImage ? 'true' : 'false' }},
    currentSrc: '',
    imgAlt: '{{ $alt }}',
    imgCaption: '{{ $caption }}',
    scrollY: 0,
    scrollbarWidth: 0,
    updateImageSrc() {
        // update the image source
        if (this.darkMode && this.hasLightSpecificImage) {
            this.currentSrc = this.defaultSrc;
        } else {
            this.currentSrc = this.lightSrc || this.defaultSrc;
        }
    },
    init() {
        // detect the current theme used
        const savedTheme = localStorage.getItem('theme');
        this.darkMode = savedTheme === 'dark';

        // Initialise image source
        this.updateImageSrc();

        // Precharge images sources
        if (this.defaultSrc) {
            const imgDefault = new Image();
            imgDefault.src = this.defaultSrc;
        }

        if (this.lightSrc && this.hasLightSpecificImage) {
            const imgLight = new Image();
            imgLight.src = this.lightSrc;
        }

        // Listen to alpine event 'theme-changed' dispatched by theme switcher
        window.addEventListener('theme-changed', (event) => {
            this.darkMode = event.detail === 'dark';
            this.updateImageSrc();
        });

        window.addEventListener('storage', (e) => {
            if (e.key === 'theme') {
                this.darkMode = e.newValue === 'dark';
                this.updateImageSrc();
            }
        });
    },
    toggleZoom() {
        if (!this.zoomed) {
            this.scrollY = window.scrollY;
            this.scrollbarWidth = window.innerWidth - document.documentElement.clientWidth;
            document.body.style.paddingRight = `${this.scrollbarWidth}px`;
            document.body.style.position = 'fixed';
            document.body.style.top = `-${this.scrollY}px`;
            document.body.style.width = '100%';
            this.zoomed = true;
        } else {
            this.zoomed = false;
            setTimeout(() => {
                document.body.style.position = '';
                document.body.style.paddingRight = '';
                document.body.style.top = '';
                document.body.style.width = '';
                window.scrollTo(0, this.scrollY);
            }, 200);
        }
    }
}"
     class="{{ $class }} relative mb-4">

    <!-- Overlay  -->
    <div x-show="zoomed"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 z-40 bg-black/80 backdrop-blur-sm"
         x-on:click="toggleZoom"
         style="display: none;"
         aria-hidden="true"></div>

    <!-- Image container -->
    <div
         class="bg-base-100/50 border-base-300 rounded-box overflow-hidden border p-2 shadow-sm transition-all duration-200 hover:shadow-md">
        <div class="rounded-box relative flex h-[22rem] flex-col justify-start overflow-hidden">
            <img x-on:click="toggleZoom"
                 style="margin: 0 !important"
                 :src="currentSrc"
                 :alt="imgAlt"
                 class="rounded-box -mb-10 -mt-10 h-full w-full flex-grow cursor-zoom-in object-cover transition-transform duration-200" />
        </div>
        <div x-show="imgCaption"
             class="px-4 py-4 text-center text-sm text-gray-400"
             x-text="imgCaption"></div>
    </div>

    <!-- Zoomed container -->
    <div x-show="zoomed"
         x-on:keydown.escape.window="toggleZoom()"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100 scale-100"
         x-transition:leave-end="opacity-0 scale-95"
         class="fixed inset-0 z-50 flex items-center justify-center p-4"
         role="dialog"
         aria-modal="true"
         aria-labelledby="image-modal-title"
         style="display: none;">

        <!-- Close button -->
        <button x-on:click="toggleZoom"
                class="btn btn-square bg-base-100 absolute right-4 top-4 z-10 border-none"
                aria-label="Fermer">
            <svg xmlns="http://www.w3.org/2000/svg"
                 fill="none"
                 viewBox="0 0 24 24"
                 stroke-width="2"
                 stroke="currentColor"
                 class="h-6 w-6">
                <path stroke-linecap="round"
                      stroke-linejoin="round"
                      d="M6 18L18 6M6 6l12 12" />
            </svg>
        </button>

        <div
             class="min-w-sm lg:min-w-5xl rounded-box relative max-h-[90vh] max-w-6xl overflow-hidden bg-transparent p-2 md:p-4">
            <img x-on:click="toggleZoom"
                 :src="currentSrc"
                 :alt="imgAlt"
                 :id="'image-modal-title'"
                 class="rounded-box h-full w-full cursor-zoom-out object-contain transition-opacity duration-300" />

            <!-- Caption for zoomed image -->
            <div x-show="imgCaption"
                 class="bg-base-200/60 text-base-content rounded-box absolute bottom-6 left-1/2 max-w-lg -translate-x-1/2 px-4 py-2 text-center text-sm"
                 x-text="imgCaption"></div>
        </div>
    </div>
</div>
