@props([
    'version' => null,
    'date' => null,
    'title' => '',
    'description' => '',
])

@php
    use Illuminate\Support\Str;
    use League\CommonMark\Util\HtmlFilter;
    use Tempest\Highlight\CommonMark\HighlightExtension;
    use Tempest\Highlight\Highlighter;
    $versionId = str_replace('.', '_', 'v' . ($version ?? 'unknown'));
@endphp

<div class="sm:flex">
    {{-- LEFT SIDE --}}
    <div class="relative z-10 sm:w-1/4 sm:gap-x-4 sm:pb-20 sm:ps-0 sm:text-end">
        <div class="sm:top-25 sm:sticky sm:end-0">
            {{-- Version badge --}}
            @if ($version)
                <div class="ps-4 sm:pe-4">
                    <a href="#{{ $versionId }}"
                       class="btn btn-xs bg-primary/10 !border-base-300 border !text-xs"
                       style="color: var(--color-base-content) !important">
                        v{{ $version }}
                    </a>
                </div>
            @endif

            {{-- Date display --}}
            @if ($date)
                <div
                     class="bg-base-200 -ms-7 mt-0.5 flex items-center gap-x-2 rounded-full border border-transparent px-3 py-2 sm:-me-7 sm:ms-0">
                    <div class="grow sm:hidden">
                        <span class="text-base-content/50 text-sm">
                            {{ $date }}
                        </span>
                    </div>
                    <div
                         class="btn btn-square btn-sm border-base-300 bg-base-100 order-1 shrink-0 items-center border sm:order-2">
                        <svg class="h-5 w-5"
                             xmlns="http://www.w3.org/2000/svg"
                             viewBox="0 0 21 21"
                             fill="currentColor">
                            <g fill="none"
                               fill-rule="evenodd"
                               stroke="currentColor"
                               stroke-linecap="round"
                               stroke-linejoin="round"
                               transform="translate(2 4)">
                                <path d="m.5 8.5 8 4 8.017-4"></path>
                                <path d="m.5 4.657 8.008 3.843 8.009-3.843-8.009-4.157z"></path>
                            </g>
                        </svg>
                    </div>
                    <div class="hidden grow sm:flex">
                        <span class="text-base-content/50 text-sm">
                            {{ $date }}
                        </span>
                    </div>
                </div>
            @endif
        </div>
    </div>
    {{-- END LEFT SIDE --}}

    {{-- RIGHT SIDE --}}
    <div class="relative pb-12 ps-8 sm:w-3/4 sm:pb-20 md:ps-12">
        <div class="absolute -top-10 bottom-0 start-0 -me-px w-px bg-gray-400/30 sm:end-0 sm:top-0 sm:-ms-px sm:me-0">
        </div>

        <div>
            <h2 id="{{ $versionId }}"
                class="z-10 !my-0 -ml-2 scroll-mt-10 [&_div]:!hidden">
                <a class="focus:outline-hidden !text-base-content hover:text-base-100 group inline-flex items-center gap-x-2 font-semibold"
                   href="#{{ $versionId }}"
                   style="color: red !important">
                </a>
                {{ $title }}
            </h2>
            <div class="-mt-2 px-2">
                @if ($description)
                    {!! Str::markdown(
                        string: $description,
                        options: [
                            'html_input' => HtmlFilter::ALLOW,
                            'allow_unsafe_links' => false,
                        ],
                        extensions: [new HighlightExtension((new Highlighter())->withGutter(startAt: 1))],
                    ) !!}
                @endif
            </div>

            <!-- Content Slot -->
            <div class="!text-base-content mt-1 space-y-4 px-2 sm:mt-10">
                {{ $slot }}
            </div>
        </div>
    </div>
    {{-- END RIGHT SIDE --}}
</div>
