@props([
    'title' => '',
    'description' => '',
    'class' => '',
    'src' => '', // https source
    'srcStorage' => '', // storage source
    'srcPublic' => '', // public storage
    'srcLight' => '', // https source 'for light light mode'
    'srcStorageLight' => '', // storage storage 'for light light mode'
    'srcPublicLight' => '', // public storage 'for light light mode'
    'alt' => '',
    'imageClass' => '',
])

@php
    // Image Source (used for both light and dark mode if no light mode image passed to src light)
    $defaultImageSrc = '';
    if (!empty($src)) {
        $defaultImageSrc = $src;
    } elseif (!empty($srcStorage)) {
        $defaultImageSrc = asset('storage/' . ltrim($srcStorage, '/'));
    } elseif (!empty($srcPublic)) {
        $defaultImageSrc = asset(ltrim($srcPublic, '/'));
    }

    // Image source for light mode (if passed, else the default one will be used)
    $lightImageSrc = '';
    if (!empty($srcLight)) {
        $lightImageSrc = $srcLight;
    } elseif (!empty($srcStorageLight)) {
        $lightImageSrc = asset('storage/' . ltrim($srcStorageLight, '/'));
    } elseif (!empty($srcPublicLight)) {
        $lightImageSrc = asset(ltrim($srcPublicLight, '/'));
    } else {
        $lightImageSrc = $defaultImageSrc;
    }

    // Verify if a light mode image has passed
    $hasLightSpecificImage = !empty($lightImageSrc) && $lightImageSrc !== $defaultImageSrc;
@endphp

<div
     {{ $attributes->merge(['class' => 'block not-prose overflow-hidden rounded-box bg-base-100/30 shadow-md hover:shadow-lg ' . $class]) }}>
    <div x-data="{
        darkMode: false,
        defaultSrc: '{{ $defaultImageSrc }}',
        lightSrc: '{{ $lightImageSrc }}',
        hasLightSpecificImage: {{ $hasLightSpecificImage ? 'true' : 'false' }},
        currentSrc: '',
        updateImageSrc() {
            if (this.darkMode && this.hasLightSpecificImage) {
                this.currentSrc = this.defaultSrc;
            } else {
                this.currentSrc = this.lightSrc || this.defaultSrc;
            }
        },
        init() {
            // detect the current theme used
            const savedTheme = localStorage.getItem('theme');
            this.darkMode = savedTheme === 'dark';
    
            // Initialise image source
            this.updateImageSrc();
    
            // Preload images
            if (this.defaultSrc) {
                const imgDefault = new Image();
                imgDefault.src = this.defaultSrc;
            }
    
            if (this.lightSrc && this.hasLightSpecificImage) {
                const imgLight = new Image();
                imgLight.src = this.lightSrc;
            }
    
            // Listen to alpine event 'theme-changed' dispatched by theme switcher
            window.addEventListener('theme-changed', (event) => {
                this.darkMode = event.detail === 'dark';
                this.updateImageSrc();
            });
    
            window.addEventListener('storage', (e) => {
                if (e.key === 'theme') {
                    this.darkMode = e.newValue === 'dark';
                    this.updateImageSrc();
                }
            });
        }
    }"
         class="rounded-box bg-base-100/50 flex h-full flex-col overflow-hidden border border-gray-400/20">
        {{-- Image area --}}
        <div class="rounded-t-box flex h-80 w-full overflow-hidden">
            <img :src="currentSrc"
                 alt="{{ $alt }}"
                 class="{{ $imageClass }} h-full w-full object-cover" />
        </div>

        {{-- Content area --}}
        <div class="flex flex-grow flex-col border-t border-gray-400/20 px-6 py-4">
            @if ($title)
                <p class="text-base-content text-lg font-medium">{{ $title }}</p>
            @endif

            @if ($description)
                <p class="text-base-content/60 mt-1 text-sm">{{ $description }}</p>
            @endif

            {{-- card content --}}
            @if (isset($slot) && !empty(trim($slot)))
                <div class="mt-4">
                    {{ $slot }}
                </div>
            @endif
        </div>
    </div>
</div>
