@props(['title', 'description', 'icon' => null, 'url' => '#', 'color' => null])

@php
    $colorClasses = [
        'warning' => [
            'border' => 'hover:border-warning/80',
            'fill' => 'fill-warning',
            'hover' => 'group-hover:fill-warning',
        ],
        'primary' => [
            'border' => 'hover:border-primary/80',
            'fill' => 'fill-primary',
            'hover' => 'group-hover:fill-primary',
        ],
        'error' => ['border' => 'hover:border-error/80', 'fill' => 'fill-error', 'hover' => 'group-hover:fill-error'],
        'success' => [
            'border' => 'hover:border-success/80',
            'fill' => 'fill-success',
            'hover' => 'group-hover:fill-success',
        ],
        'info' => ['border' => 'hover:border-info/80', 'fill' => 'fill-info', 'hover' => 'group-hover:fill-info'],
    ];

    $selectedColor = $colorClasses[$color] ?? $colorClasses['primary'];
    $iconClasses = $selectedColor['fill'];
    $linkIconClasses = $selectedColor['hover'];

    $cacheKey = 'icon_' . md5($icon . $iconClasses);
    $iconContent = cache()->remember($cacheKey, now()->addMinutes(60), function () use ($icon, $iconClasses) {
        if ($icon) {
            try {
                return svg($icon, 'w-6 h-6 ' . $iconClasses)->toHtml();
            } catch (\Throwable $e) {
                return '<svg class="' .
                    $iconClasses .
                    ' h-5 w-5" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M14.5 3a.5.5 0 0 1 .5.5v9a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5zm-13-1A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5v-9A1.5 1.5 0 0 0 14.5 2z"></path> <path d="M3 8.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5m0-5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-9a.5.5 0 0 1-.5-.5z"></path></svg>';
            }
        }
    });
@endphp

<div
     {{ $attributes->merge(['class' => 'block not-prose group relative ring-2 ring-transparent rounded-box bg-base-100/50 border border-gray-400/20 overflow-hidden w-full cursor-pointer px-6 py-5' . ' ' . $selectedColor['border']]) }}>
    <a href="{{ $url }}"
       class="flex flex-col space-y-4 text-left">
        <div class="flex items-center justify-between">
            <div class="rounded-box mb-1 flex items-center justify-center">
                {!! $iconContent !!}
            </div>

            {{-- Link icon --}}
            <svg class="{{ $linkIconClasses }} fill-base-content/50 h-6 w-6"
                 xmlns="http://www.w3.org/2000/svg"
                 viewBox="0 0 20 20">
                <path
                      d="M11.75 4.5a.75.75 0 0 0 0 1.5h1.19l-2.72 2.72a.75.75 0 1 0 1.06 1.06l2.72-2.72v1.19a.75.75 0 0 0 1.5 0v-3a.75.75 0 0 0-.75-.75h-3Z" />
                <path
                      d="M15 11.25a.75.75 0 0 0-1.5 0v1c0 .69-.56 1.25-1.25 1.25h-4.5c-.69 0-1.25-.56-1.25-1.25v-4.5c0-.69.56-1.25 1.25-1.25h1a.75.75 0 0 0 0-1.5h-1a2.75 2.75 0 0 0-2.75 2.75v4.5a2.75 2.75 0 0 0 2.75 2.75h4.5a2.75 2.75 0 0 0 2.75-2.75v-1Z" />
            </svg>
        </div>

        <div class="space-y-1">
            <span class="text-base-content text-lg font-semibold">{{ $title }}</span>
            <p class="mt-2 text-sm !text-gray-400">{{ $description }}</p>
        </div>
    </a>
</div>
