@props(['name', 'expandable' => true, 'initialHeight' => '100px', 'minExpandedHeight' => '40px'])

<div x-data="{
    expanded: false,
    activeTab: null,
    initialize() {
        this.$nextTick(() => {
            // get default active tab
            this.activeTab = this.$refs.tabHeadings.querySelector('[data-active=true]')?.dataset.name;

            // If no default active tab is set, we'll use the first one
            if (!this.activeTab && this.$refs.tabHeadings.querySelector('[data-name]')) {
                this.activeTab = this.$refs.tabHeadings.querySelector('[data-name]').dataset.name;
            }
        });
    }
}"
     x-init="initialize()"
     class="not-prose bg-base-200 rounded-box group relative mb-8 mt-5 overflow-auto border border-gray-400/20">

    {{-- Tab headings --}}
    <div x-ref="tabHeadings"
         class="bg-base-300/20 rounded-t-box flex overflow-x-auto border-b border-gray-400/20 text-xs font-semibold leading-6">
        {{ $headings }}
    </div>

    {{-- Tab content container --}}
    <div class="relative min-w-full text-sm leading-6"
         :style="expanded ? { minHeight: '{{ $minExpandedHeight }}' } : !{{ json_encode($expandable) }} ? {} :
         { height: '{{ $initialHeight }}' }">

        {{-- Tab bodies --}}
        <div
             class="scrollbar-hidden scrollbar-thumb-white/20 dark:scrollbar-thumb-white/20 h-full w-full overflow-hidden overflow-y-auto p-2 [&_pre]:overflow-auto">
            {{ $slot }}
        </div>

        @if ($expandable)
            {{-- Expand overlay (non-expanded state) --}}
            <div x-show="!expanded"
                 class="to-base-200 from-base-200/6 rounded-box absolute left-0 right-0 top-0 z-[10] flex h-full items-end justify-center bg-transparent bg-gradient-to-b">
                {{-- Expand Button --}}
                <button x-on:click="expanded = true"
                        class="rounded-field btn btn-xs btn-ghost bg-base-100 text-primary-content hover:bg-base-100/90 mb-4 flex items-center gap-2 border-none px-2 py-1.5 transition-colors">
                    <svg xmlns="http://www.w3.org/2000/svg"
                         width="24"
                         height="24"
                         viewBox="0 0 24 24"
                         fill="none"
                         stroke="currentColor"
                         stroke-width="2"
                         stroke-linecap="round"
                         stroke-linejoin="round"
                         class="lucide lucide-arrow-down duration-400 size-3 transition-transform">
                        <path d="M12 5v14"></path>
                        <path d="m19 12-7 7-7-7"></path>
                    </svg>
                    Expand code
                </button>
            </div>

            {{-- Collapse Button in expanded state --}}
            <div x-show="expanded"
                 class="bg-base-200 sticky bottom-0 left-0 right-0 z-[10] flex items-center justify-center border-t border-gray-400/20 py-3">
                <button x-on:click="expanded = false"
                        class="rounded-field btn btn-xs btn-ghost bg-base-100 text-primary-content hover:bg-base-100/90 flex items-center gap-2 border-none px-2 py-1.5 transition-colors">
                    <svg xmlns="http://www.w3.org/2000/svg"
                         width="24"
                         height="24"
                         viewBox="0 0 24 24"
                         fill="none"
                         stroke="currentColor"
                         stroke-width="2"
                         stroke-linecap="round"
                         stroke-linejoin="round"
                         class="lucide lucide-arrow-up duration-400 size-3 transition-transform">
                        <path d="M12 19V5"></path>
                        <path d="m5 12 7-7 7 7"></path>
                    </svg>
                    Collapse code
                </button>
            </div>
        @endif
    </div>
</div>
