<?php

namespace Converge\ConvergeComponents;


use Illuminate\Support\ServiceProvider;
class ConvergeComponentsServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../config/converge-components.php', 'converge'
        );
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../config/converge-components.php' => config_path('converge-components.php'),
        ], 'converge-components-config');

        $this->loadViewsFrom(__DIR__.'/../resources/views', 'converge');

        $this->publishes([
            __DIR__.'/../resources/views' => resource_path('views/components/converge'),
        ], 'converge-components-views');

        $this->publishes([
            __DIR__.'/../dist' => public_path('vendor/converge/components'),
        ], 'converge-components-assets');
    }
}
