<?php

namespace Converge\ConvergeComponents;

use Carbon\Carbon;
use WendellAdriel\ValidatedDTO\Attributes\Rules;
use WendellAdriel\ValidatedDTO\Casting\CarbonCast;
use WendellAdriel\ValidatedDTO\Concerns\EmptyRules;
use WendellAdriel\ValidatedDTO\ValidatedDTO;


class YouTubeVideoDTO extends ValidatedDTO
{
    use EmptyRules;

    // The title of the video
    #[Rules(['required', 'string'])]
    public string $title;

    // The YouTube video ID
    #[Rules(['required', 'string'])]
    public string $videoId;

    // The date and time the video was first published, in ISO 8601 format
    #[Rules(['required'])]
    public Carbon $publishedAt;

    // The description of the video
    #[Rules(['nullable', 'string'])]
    public ?string $description;

    // The duration of the video in ISO 8601 format (e.g., PT00H30M5S)
    #[Rules(['nullable', 'string'])]
    public ?string $duration;

    /**
     * Default values for Schema.org structured data
     *
     * @return array<string, string>
     */
    protected function defaults(): array
    {
        return [
            '@context' => '
            ',
            '@type' => 'VideoObject',
            'thumbnailUrl' => 'https://i.ytimg.com/vi/'.$this->videoId.'/maxresdefault.jpg',
            'embedUrl' => 'https://www.youtube.com/embed/'.$this->videoId,
        ];
    }

    /**
     * Map external field names to class properties
     *
     * @return array<string, string>
     */
    protected function mapData(): array
    {
        return [
            'video_id' => 'videoId',
            'video_title' => 'title',
            'published_date' => 'publishedAt',
        ];
    }

    /**
     * Type casting configurations
     *
     * @return array<string, mixed>
     */
    protected function casts(): array
    {
        return [
            'publishedAt' => new CarbonCast,
        ];
    }
}
