@props(['title', 'description', 'icon' => null, 'url' => null, 'color' => 'primary'])

@php
    $colorClasses = [
        'warning' => [
            'border' => 'hover:border-warning/80',
            'fill' => 'fill-warning',
            'hover' => 'group-hover:fill-warning',
        ],
        'primary' => [
            'border' => 'hover:border-primary/80',
            'fill' => 'fill-primary',
            'hover' => 'group-hover:fill-primary',
        ],
        'error' => ['border' => 'hover:border-error/80', 'fill' => 'fill-error', 'hover' => 'group-hover:fill-error'],
        'success' => [
            'border' => 'hover:border-success/80',
            'fill' => 'fill-success',
            'hover' => 'group-hover:fill-success',
        ],
        'info' => ['border' => 'hover:border-info/80', 'fill' => 'fill-info', 'hover' => 'group-hover:fill-info'],
    ];

    $selectedColor = $colorClasses[$color] ?? $colorClasses['primary'];
    $iconClasses = $selectedColor['fill'];
    $linkIconClasses = $selectedColor['hover'];

    $cacheKey = 'icon_' . md5(($icon ?? '') . $iconClasses);
    $iconContent = null;

    $iconContent = cache()->remember($cacheKey, now()->addMinutes(60), function () use ($icon, $iconClasses) {
        try {
            return svg($icon, 'w-6 h-6 ' . $iconClasses)->toHtml();
        } catch (\Throwable $e) {
            return '<svg class="' .
                $iconClasses .
                ' h-5 w-5" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"><path d="M14.5 3a.5.5 0 0 1 .5.5v9a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-9a.5.5 0 0 1 .5-.5zm-13-1A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5v-9A1.5 1.5 0 0 0 14.5 2z"></path> <path d="M3 8.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5m0-5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-9a.5.5 0 0 1-.5-.5z"></path></svg>';
        }
    });
@endphp

<div
     {{ $attributes->merge(['class' => 'block not-prose group relative ring-2 ring-transparent rounded-box bg-base-100/50 border border-gray-400/20 overflow-hidden w-full ' . $selectedColor['border']]) }}>
    <div class="flex h-full flex-col">
        <div class="px-6 py-5">
            <div class="flex items-start gap-4">
                @if ($iconContent)
                    <div class="mt-1 shrink-0">
                        {!! $iconContent !!}
                    </div>
                @endif
                <div class="flex-grow">
                    <p class="mb-1 text-lg font-medium">{{ $title }}</p>
                    <div class="text-base-content/70">{{ $description }}</div>
                </div>
            </div>
        </div>
    </div>
</div>
