@props([
    'filename',
    'language' => 'php',
    'expandable' => true,
    'initialHeight' => '100px',
    'minExpandedHeight' => '300px',
])
@php
    use Illuminate\Support\Str;
    use League\CommonMark\Util\HtmlFilter;
    use Tempest\Highlight\CommonMark\HighlightExtension;
    use Tempest\Highlight\Highlighter;
@endphp

<div x-data="{ expanded: false }"
     class="not-prose bg-base-200 rounded-box group relative mb-8 mt-5 overflow-auto border border-gray-400/20">

    {{-- file name --}}
    <div class="bg-base-300/20 rounded-t-field flex border-b border-gray-400/20 text-xs font-semibold leading-6">
        <div class="!text-primary border-primary flex flex-none items-center border-b px-4 pb-2 pt-2.5">
            {{ $filename }}
        </div>
    </div>

    <div class="relative min-w-full !p-0 text-sm leading-6"
         :style="expanded ? { minHeight: '{{ $minExpandedHeight }}' } : !{{ json_encode($expandable) }} ? {} :
         { height: '{{ $initialHeight }}' }">

        {{-- code content --}}
        <div
             class="scrollbar-hidden scrollbar-thumb-white/20 code-frame dark:scrollbar-thumb-white/20 scrollbar-hidden h-full w-full overflow-hidden overflow-y-auto [&_pre]:overflow-auto">
            {!! Str::markdown(
                string: $slot,
                options: [
                    'html_input' => HtmlFilter::ALLOW,
                    'allow_unsafe_links' => false,
                ],
                extensions: [new HighlightExtension((new Highlighter())->withGutter(startAt: 1))],
            ) !!}
        </div>

        @if ($expandable)
            {{-- Expand overlay (non-expanded state) --}}
            <div x-show="!expanded"
                 class="to-base-200 from-base-200/6 rounded-box absolute left-0 right-0 top-0 z-[10] flex h-full items-end justify-center bg-transparent bg-gradient-to-b">

                {{-- Expand Button --}}
                <button x-on:click="expanded = true"
                        class="rounded-field btn btn-xs btn-ghost bg-base-100 text-primary-content hover:bg-base-100/90 mb-4 flex items-center gap-2 border-none px-2 py-1.5 transition-colors">
                    <svg xmlns="http://www.w3.org/2000/svg"
                         width="24"
                         height="24"
                         viewBox="0 0 24 24"
                         fill="none"
                         stroke="currentColor"
                         stroke-width="2"
                         stroke-linecap="round"
                         stroke-linejoin="round"
                         class="lucide lucide-arrow-down duration-400 size-3 transition-transform">
                        <path d="M12 5v14"></path>
                        <path d="m19 12-7 7-7-7"></path>
                    </svg>
                    Expand code
                </button>
            </div>

            {{-- Collapse Button in expanded state --}}
            <div x-show="expanded"
                 class="bg-base-200 sticky bottom-0 left-0 right-0 z-[10] flex items-center justify-center border-t border-gray-400/20 py-3">
                <button x-on:click="expanded = false"
                        class="rounded-field btn btn-xs btn-ghost bg-base-100 text-primary-content hover:bg-base-100/90 flex items-center gap-2 border-none px-2 py-1.5 transition-colors">
                    <svg xmlns="http://www.w3.org/2000/svg"
                         width="24"
                         height="24"
                         viewBox="0 0 24 24"
                         fill="none"
                         stroke="currentColor"
                         stroke-width="2"
                         stroke-linecap="round"
                         stroke-linejoin="round"
                         class="lucide lucide-arrow-up duration-400 size-3 transition-transform">
                        <path d="M12 19V5"></path>
                        <path d="m5 12 7-7 7 7"></path>
                    </svg>
                    Collapse code
                </button>
            </div>
        @endif
    </div>
</div>
